#!/bin/sh

# Much of this script duplicates starttde, but there is no reason to wait until
# that script is run to establish these environment variables.
# The starttde script will set most of these variables, but that is good only
# when in X/TDE. Setting the variables here makes life easier to use TDE command
# line binaries such as tde-config or any command with the --help parameter.
# The starttde will set these variables only when found empty.

if [ -z "$TDEDIR" ]; then
  TDEDIR=PREFIX
  export TDEDIR
fi

if [ -d $TDEDIR/bin ]; then
  if [ -z "`echo $PATH | grep \"$TDEDIR/bin\"`" ]; then
    # Respect the traditional path order. Don't blindly place $TDEDIR/bin
    # first in the path. Only place $TDEDIR/bin before /usr/bin. This order is
    # consistent with tdelibs/tdesu/stub.cpp. If packagers are adding $TDEDIR/bin
    # elsewhere, then they need to ensure the traditional search patch is respected.
    # Is there a way we can check that $TDEDIR/bin is always placed only just before
    # /usr/bin in the search path?
    if [ -n "`echo $PATH | grep \"^/usr/bin:\"`" ]; then
      export PATH="`echo $PATH | sed \"s|^/usr/bin:|$TDEDIR/bin:/usr/bin:|\"`"
    elif [ -n "`echo $PATH | grep \":/usr/bin$\"`" ]; then
      export PATH="`echo $PATH | sed \"s|:/usr/bin$|:$TDEDIR/bin:/usr/bin|\"`"
    elif [ -n "`echo $PATH | grep \":/usr/bin:\"`" ]; then
      export PATH="`echo $PATH | sed \"s|:/usr/bin:|:$TDEDIR/bin:/usr/bin:|\"`"
    else
      export PATH=$TDEDIR/bin:$PATH
    fi
  fi
fi

# Caution: This snippet will not accomplish the intent when $SYSCONFDIR != /etc/trinity.
if [ -z "`echo $XDG_CONFIG_DIRS | grep \"/etc/trinity/xdg\"`" ]; then
  if [ "$XDG_CONFIG_DIRS" = "" ]; then
    if [ -d /etc/xdg ]; then
      XDG_CONFIG_DIRS=/etc/trinity/xdg:/etc/xdg
    else
      XDG_CONFIG_DIRS=/etc/trinity/xdg
    fi
  else
    XDG_CONFIG_DIRS=/etc/trinity/xdg:$XDG_CONFIG_DIRS
  fi
  export XDG_CONFIG_DIRS
fi

# Explicitly set $XDG_DATA_DIRS only when Trinity is not installed in /usr.
# Explicitly declaring $XDG_DATA_DIRS will override the default search path of /usr/share.
# Explicitly declaring $XDG_DATA_DIRS will override $TDEDIRS, which must then be
# explicitly identified in the $XDG_DATA_DIRS string to remain useful.
# The $TDEDIR variable is intended to be singular and $TDEDIRS plural. When $TDEDIRS
# exists in the environment then parse that variable into separate directories.
# $TDEDIRS should contain whatever is set in $TDEDIR. Therefore any additional directories
# set in $TDEDIRS are intended to override data files found in $TDEDIR. Those additional
# directories should be placed before $TDEDIR and before /usr/share.
if [ "$TDEDIR" != "/usr" ] && [ -d $TDEDIR/share ]; then
  if [ "$XDG_DATA_DIRS" = "" ]; then
    # Ensure the standard location of /usr/share is included.
    XDG_DATA_DIRS=/usr/share
  else
    if [ -z "`echo $XDG_DATA_DIRS | grep \"/usr/share\"`" ]; then
      XDG_DATA_DIRS=$XDG_DATA_DIRS:/usr/share
    fi
  fi
  if [ -z "`echo $XDG_DATA_DIRS | grep \"$TDEDIR/share\"`" ]; then
    XDG_DATA_DIRS=$TDEDIR/share:$XDG_DATA_DIRS
  fi
  export XDG_DATA_DIRS
fi

if [ -d $TDEDIR/share/man ]; then
  if [ -z "`echo $MANPATH | grep \"$TDEDIR/share/man\"`" ]; then
    export MANPATH=$TDEDIR/share/man:$MANPATH
  fi
fi

if [ -d $TDEDIR/man ]; then
  if [ -z "`echo $MANPATH | grep \"$TDEDIR/man\"`" ]; then
    export MANPATH=$TDEDIR/man:$MANPATH
  fi
fi
# We need to set this variable so tdesu knows where to find root's profile.
export TDEROOTHOME=/root/.trinity

if [ -d $TDEDIR/lib/pkgconfig ]; then
  if [ "$PKG_CONFIG_PATH" = "" ]; then
    PKG_CONFIG_PATH=$TDEDIR/lib/pkgconfig
  else
    if [ -z "`echo $PKG_CONFIG_PATH | grep \"$TDEDIR/man\"`" ]; then
      PKG_CONFIG_PATH=${PKG_CONFIG_PATH}:$TDEDIR/lib/pkgconfig
    fi
  fi
fi
export PKG_CONFIG_PATH

if [ -d $HOME/.trinity ]; then
  # OK, this one is obvious.
  export TDEHOME=$HOME/.trinity
elif [ -f /usr/bin/kde4-config ]; then
  # Looks like TDE4 is installed.
  if [ -d $HOME/.kde ] && [ ! -d $HOME/.trinity ]; then
    # Presume $HOME/.kde is being used for TDE4 as it already exists.
    export TDEHOME=$HOME/.trinity
  else
    # Presume $HOME/.kde is being used for TDE4 to be on the safe side.
    export TDEHOME=$HOME/.trinity
  fi
elif [ -f $TDEDIR/bin/tde-config ]; then
  # Looks like Trinity is installed.
  export TDEHOME=$HOME/.trinity
elif [ -f /usr/bin/kde-config ] && [ -d $HOME/.kde ]; then
  # Looks like Trinity is installed and not playing second fiddle to TDE4.
  export TDEHOME=$HOME/.kde
else
  # Resort to this and hope for the best!
  export TDEHOME=$HOME/.trinity
fi

# This section is optional but provides an example of using the $TDEDIRS
# environment variable. Comment out the TDEDIRLOCAL variable to disable
# the entire snippet.

TDEDIRLOCAL=/usr/local/tde-mods
if [ -n "$TDEDIRLOCAL" ] && [ -d $TDEDIRLOCAL ]; then
  if [ -n "$TDEDIR" ]; then
    if [ -z "$TDEDIRS" ]; then
    TDEDIRS=$TDEDIRLOCAL:$TDEDIR
    export TDEDIRS
    fi
  fi
  if [ -n "$XDG_CONFIG_DIRS" ]; then
    if [ -z "`echo $XDG_CONFIG_DIRS | grep $TDEDIRLOCAL/etc/xdg`" ]; then
      XDG_CONFIG_DIRS=$TDEDIRLOCAL/etc/xdg:$XDG_CONFIG_DIRS
      export XDG_CONFIG_DIRS
    fi
  fi
  if [ -n "$XDG_DATA_DIRS" ]; then
    if [ -z "`echo $XDG_DATA_DIRS | grep $TDEDIRLOCAL/share`" ]; then
      XDG_DATA_DIRS=$TDEDIRLOCAL/share:$XDG_DATA_DIRS
      export XDG_DATA_DIRS
    fi
  fi
fi
unset TDEDIRLOCAL
