#!/bin/csh
# Much of this script duplicates starttde, but there is no reason to wait until
# that script is run to establish these environment variables.
# The starttde script will set most of these variables, but that is good only
# when in X/TDE. Setting the variables here makes life easier to use TDE command
# line binaries such as tde-config or any command with the --help parameter.
# The starttde will set these variables only when found empty.

if ( ! $TDEDIR ) then
    setenv TDEDIR PREFIX
endif

if ( -d $TDEDIR/share ) then
  if ( ! "`echo $XDG_DATA_DIRS | grep \"$TDEDIR/share\"`" ) then
    if ( ! "$XDG_DATA_DIRS" ) then
      XDG_DATA_DIRS $TDEDIR/share
    else
      XDG_DATA_DIRS $XDG_DATA_DIRS:$TDEDIR/share
    endif
    setenv XDG_DATA_DIRS
  endf
endif

if ( ! $TDEDIR ) then
    setenv TDEDIR $TDEDIR
endif
if ( $XDG_CONFIG_DIRS ) then
  setenv XDG_CONFIG_DIRS ${XDG_CONFIG_DIRS}:/etc/trinity/xdg
else
  setenv XDG_CONFIG_DIRS /etc/xdg:/etc/trinity/xdg
endif

setenv PATH $TDEDIR/bin:$PATH
setenv MANPATH $TDEDIR/man:$MANPATH
# We need to set this variable so kdesu knows where to find root's profile.
setenv KDEROOTHOME /root/.trinity

if ( ! $PKG_CONFIG_PATH ) then
  setenv PKG_CONFIG_PATH $TDEDIR/lib/pkgconfig
else
  setenv PKG_CONFIG_PATH ${PKG_CONFIG_PATH}:$TDEDIR/lib/pkgconfig
fi

if ( $HOME/.trinity ) then
  # OK, this one is obvious.
  setenv KDEHOME $HOME/.trinity
elif ( /usr/bin/kde4-config ) then
  # Looks like KDE4 is installed.
  if ( $HOME/.kde ] && ( ! $HOME/.trinity ) then
    # Presume $HOME/.kde is being used for KDE4 as it already exists.
    setenv KDEHOME $HOME/.trinity
  else
    # Presume $HOME/.kde is being used for KDE4 to be on the safe side.
    setenv KDEHOME $HOME/.trinity
  fi
elif ( /opt/trinity/bin/tde-config ) then
  # Looks like Trinity is installed.
  setenv KDEHOME $HOME/.trinity
elif ( /usr/bin/kde-config ) && ( -d $HOME/.kde ) then
  # Looks like Trinity is installed and not playing second fiddle to KDE4.
  setenv KDEHOME $HOME/.kde
else
  # Resort to this and hope for the best!
  setenv KDEHOME $HOME/.trinity
fi

# This section is optional but provides an example of using the $TDEDIRS
# environment variable.

TDEDIRLOCAL=/usr/local/tde-mods
if ( -d $TDEDIRLOCAL ) then
  if ( -n "$TDEDIR" ) then
    TDEDIRS $TDEDIRLOCAL:$TDEDIR
    setenv TDEDIRS
  fi
fi
unset TDEDIRLOCAL
