# Save old config files:
# if [ ! -L etc/X11/tdm ]; then
#   if [ -d etc/X11/tdm ]; then
#     mkdir -p etc/DESKTOP/tdm
#     cp -a etc/X11/tdm/* etc/DESKTOP/tdm
#     rm -rf etc/X11/tdm
#     ( cd etc/X11 ; ln -sf /etc/DESKTOP/tdm tdm )
#   fi
# elif [ ! -e etc/X11/tdm ]; then
#   mkdir -p etc/X11
#   ( cd etc/X11 ; ln -sf /etc/DESKTOP/tdm tdm )
# fi

# Use new xwmconfig but save the original
mv /usr/bin/xwmconfig /usr/bin/xwmconfig.orig
mv /usr/bin/xwmconfig.new /usr/bin/xwmconfig

#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/DESKTOP/tdm/tdmrc.new
config etc/DESKTOP/tdm/backgroundrc.new
config etc/X11/xinit/xinitrc.DESKTOP.new
config etc/profile.d/DESKTOP.sh.new
# config etc/profile.d/DESKTOP.csh.new
config usr/bin/starttde.new

if [ -x /sbin/ldconfig ]; then
  /sbin/ldconfig 2> /dev/null
fi
